/*
 * @(#)ShadowRectangleFigure.java  2.0  2006-01-16
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.rer.diagram;

import org.jhotdraw.draw.RectangleFigure;
import org.jhotdraw.draw.action.ImageBevelBorder;
import ch.randelshofer.util.*;
import java.awt.*;
import java.awt.geom.*;
import javax.swing.*;
import javax.swing.border.*;
import static org.jhotdraw.draw.AttributeKeys.*;
import org.jhotdraw.geom.*;

/**
 * A rectangle with a cast shadow.
 *
 * @author  Werner Randelshofer
 * @version 2.0 2006-01-16 Changed to support double precision coordinates.
 * <br>1.0 1. Dezember 2003  Created.
 */
public class ShadowRectangleFigure extends RectangleFigure {
    protected Border border;
    protected final static JComponent borderComponent = new JPanel();
    private static Insets2D.Double shadowInsets = new Insets2D.Double(0, 2, 5, 4);
    private static Border shadowBorder;
    
    /** Creates a new instance. */
    public ShadowRectangleFigure() {
        if (shadowBorder == null) {
            shadowBorder = new ImageBevelBorder(
                    Toolkit.getDefaultToolkit().createImage(
                    getClass().getResource("/ch/randelshofer/draw/images/shadow.png")),
                    new Insets(8, 7, 8, 7),
                    new Insets(1, 3, 5, 3),
                    false
                    );
        }
        border = shadowBorder;
    }
    
    public void draw(Graphics2D g) {
        Rectangle2D.Double bounds = getShadowBounds();
        // FIXME - We need a border that supports float coordinates
        border.paintBorder(borderComponent, g, (int) bounds.x, (int) bounds.y, (int) bounds.width, (int) bounds.height);
        super.draw(g);
    }
    
    private Rectangle2D.Double getShadowBounds() {
        Rectangle2D.Double r = getBounds();
        double width = STROKE_WIDTH.get(this) / 2d;
        r.x -= width + shadowInsets.left;
        r.y -= width + shadowInsets.top;
        r.width += width * 2 + shadowInsets.left + shadowInsets.right;
        r.height += width * 2 + shadowInsets.top + shadowInsets.bottom;
        return r;
    }
    
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r = super.getDrawingArea();
        r.x -= shadowInsets.left;
        r.y -= shadowInsets.top;
        r.width += shadowInsets.left + shadowInsets.right;
        r.height += shadowInsets.top + shadowInsets.bottom;
        return r;
    }
}
